import os
import sys
sys.path.append('/home/leo/particle/TrafficFluids/')
sys.path.append('../datasets')
import numpy as np
from glob import glob
from tensorpack import dataflow
import pandas as pd
import helper
from datasets.dataset_reader_argoverse import read_data_train, read_data_val
from argoverse.data_loading.argoverse_forecasting_loader import ArgoverseForecastingLoader
from argoverse.map_representation.map_api import ArgoverseMap
import pickle

from evaluate_network import evaluate


dataset_path = '/home/leo/particle/argoverse/argoverse_forecasting'

test_path = os.path.join(dataset_path, 'val', 'data')


def create_model():
    from models.default import MyParticleNetwork
    """Returns an instance of the network for training and evaluation"""
    model = MyParticleNetwork()
    return model


def match_pr_gt(pr, gt, pr_id, gt_id, tensor=True):
    
    if isinstance(pr_id, tf.Tensor):
        pr_id = pr_id.numpy
    if isinstance(gt_id, tf.Tensor):
        gt_id = gt_id.numpy
    
    pr_in = np.isin(pr_id, np.intersect1d(pr_id, gt_id))
    gt_in = np.isin(gt_id, np.intersect1d(pr_id, gt_id))
    
    if isinstance(pr, tf.Tensor):
        gt_match = pr.numpy()
    else:
        gt_match = pr
    
    adj_term = np.mean(np.linalg.norm(gt_match[pr_in] - gt[gt_in]))
    gt_match += adj_term
    gt_match[pr_in] = gt[gt_in]
    
    if tensor:
        gt_match = tf.convert_to_tensor(gt_match, dtype=np.float32)
    
    return gt_match


def main():
    am = ArgoverseMap()
    
    test_dataset = read_data_val(test_path, window=1, cache_data=True)
    
    model0 = create_model()
    model0.init()
    model0.load_weights('model_weights_1t_map.h5', by_name=True)
    
    result = evaluate(model0, test_dataset, frame_skip=40, am=am)
    with open('evaluation_1t_map.pickle', 'wb') as f:
        pickle.dump(result, f)
        
    return 0


if __name__ == '__main__':
    import multiprocessing as mp
    mp.set_start_method('spawn')
    sys.exit(main())

